//Caption: To Design an Low Pass FIR Filter
//Filter Length =5, Order = 4
//Window = Rectangular Window
clc;
clear;
xdel(winsid());
fc = input("Enter Analog cutoff freq. in Hz=")
fs = input("Enter Analog sampling freq. in Hz=")
M = input("Enter order of filter =")
w = (2*%pi)*(fc/fs);
disp(w,'Digital cutoff frequency in radians.cycles/samples');
wc = w/%pi;
disp(wc,'Normalized digital cutoff frequency in cycles/samples');
[wft,wfm,fr]=wfir('lp',M+1,[wc/2,0],'re',[0,0]);
disp(wft,'Impulse Response of LPF FIR Filter:h[n]=');
//Plotting the Magnitude Response of LPF FIR Filter
subplot(2,1,1)
plot(2*fr,wfm)
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)
subplot(2,1,2)
plot(fr*fs,wfm)
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)
//Example
//Enter Analog cutoff freq. in Hz= 250
//
//Enter Analog sampling freq. in Hz= 2000
//
//Enter order of filter = 4
// 
// Digital cutoff frequency in radians.cycles/samples   
// 
//    0.7853982  
// 
// Normalized digital cutoff frequency in cycles/samples   
// 
//    0.25  
// 
// Impulse Response of LPF FIR Filter:h[n]=   
// 
//    0.1591549    0.2250791    0.25    0.2250791    0.1591549
